﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter_06
{
    enum Months { Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec }

    enum Weekday { Mon = 1, Tue, Wed, Thu, Fri, Sat = 10, Sun }

    enum Month : byte
    {
        January,
        February,
        March,
        April,
        May,
        June,
        July,
        August,
        September,
        October,
        November,
        December
    }

    class MyClass { }

    class Program
    {
        static void Main(string[] args)
        {
            // tablice

            char[] bookName = "C# Księga eksperta".ToCharArray();

            for (int i = 0; i < bookName.Length; i++)
            {
                Console.WriteLine(bookName[i]);
            }

            // tablice jednowymiarowe

            // deklaracja bez inicjalizacji
            MyClass[] myArray;
            byte[] inputBuffer = new byte[2048];

            // tworzy tablicę składającą się z trzech łańcuchów
            string[] countStrings = { "eins", "zwei", "drei" };

            for (int i = 0; i < countStrings.Length; i++)
            {
                Console.WriteLine(countStrings[i]);
            }

            string first = countStrings[0];
            string last = countStrings[2];
            //string error = countStrings[3]; // błąd

            countStrings[1] = "dwa";
            //countStrings[5] = "sześć"; // błąd

            foreach (var count in countStrings)
            {
                Console.WriteLine(count);
            }

            // tablice wielowymiarowe

            long[,] determinant = new long[4, 4];
            int[ , , ] stateSpace = new int[2, 5, 4];

            bool[,] exclusiveOr
                    = new bool[2, 2] { { false, true }, { true, false } };

            bool[,] exclusiveOr2
                     = new bool[,] { { false, true }, { true, false } };


            int dimOneSize = 2;
            int dimTwoSize = 2;

            for (int i = 0; i < dimOneSize; i++)
            {
                for (int j = 0; j < dimTwoSize; j++)
                {
                    Console.WriteLine(
                        "exclusiveOr[{0}, {1}]: {2}",
                        i, j, exclusiveOr[i, j]);
                }
            }

            exclusiveOr[0, 1] = true;

            bool bResult = exclusiveOr[1, 1];

            // tablice postrzępione

            decimal[][] monthlyVariations = new decimal[12][];

            int jan = 0;
            int feb = 1;
            int mar = 2;
            int apr = 3;
            int may = 4;
            int jun = 5;
            int jul = 6;
            int aug = 7;
            int sep = 8;
            int oct = 9;
            int nov = 10;
            int dec = 11;

            monthlyVariations[jan] = new decimal[31];
            monthlyVariations[feb] = new decimal[28];
            monthlyVariations[mar] = new decimal[31];
            monthlyVariations[apr] = new decimal[30];
            monthlyVariations[may] = new decimal[31];
            monthlyVariations[jun] = new decimal[30];
            monthlyVariations[jul] = new decimal[31];
            monthlyVariations[aug] = new decimal[31];
            monthlyVariations[sep] = new decimal[30];
            monthlyVariations[oct] = new decimal[30];
            monthlyVariations[nov] = new decimal[30];
            monthlyVariations[dec] = new decimal[31];

            decimal daily = monthlyVariations[jan][15];

            monthlyVariations[dec][13] = 1.59m;

            for (int i = 0; i < monthlyVariations.Length; i++)
            {
                for (int j = 0; j < monthlyVariations[i].Length; j++)
                {
                    Console.WriteLine(monthlyVariations[i][j]);
                }
            }

            foreach (var month in monthlyVariations)
            {
                foreach (var day in month)
                {
                    Console.WriteLine(day);
                }
            }

            // typ System.Array

            for (int i = exclusiveOr.GetLowerBound(0); 
                     i <= exclusiveOr.GetUpperBound(0); i++)
            {
                for (int j = exclusiveOr.GetLowerBound(1); 
                         j <= exclusiveOr.GetUpperBound(1); j++)
                {
                    Console.WriteLine(
                        "exclusiveOr[{0}, {1}]: {2}",
                        i, j, exclusiveOr[i, j]);
                }
            }

            Array kelvinTemperature = Array.CreateInstance(
                typeof(double), 
                new int[] { 201 }, 
                new int[] { -100 });

            int[] numbers = { 2, 9, 7, 3, 5 };

            int position = Array.BinarySearch(numbers, 3);

            Console.WriteLine("pozycja (przed sortowaniem): " + position);

            Array.Sort(numbers);

            position = Array.BinarySearch(numbers, 3);

            Console.WriteLine("pozycja (po sortowaniu): " + position);

            int idxOf = Array.IndexOf(numbers, 9);
            int lIdxOf = Array.LastIndexOf(numbers, 5);

            Console.WriteLine("IndexOf: {0}, LastIndexOf: {1}", idxOf, lIdxOf);

            Array.Reverse(numbers);

            foreach (var number in numbers)
            {
                Console.Write("{0}, ", number);
            }
            Console.WriteLine();

            // typy wyliczeniowe

            Months currentMonth = Months.Nov;

            switch (currentMonth)
            {
                case Months.Jan:
                    break;
                case Months.Feb:
                    break;
                case Months.Mar:
                    break;
                case Months.Apr:
                    break;
                case Months.May:
                    break;
                case Months.Jun:
                    break;
                case Months.Jul:
                    break;
                case Months.Aug:
                    break;
                case Months.Sep:
                    break;
                case Months.Oct:
                    break;
                case Months.Nov:
                    break;
                case Months.Dec:
                    break;
                default:
                    break;
            }

            DateTime availableDate = FindAvailableDate(currentMonth);

            //Console.Write("Podaj 3-znakowy skrót nazwy tygodnia (np. Mon): ");
            //string dayStr = Console.ReadLine();
            //Weekday wkDay = (Weekday)Enum.Parse(typeof(Weekday), dayStr);

            string dayStr = Enum.GetName(typeof(Weekday), Weekday.Thu);
            dayStr = Weekday.Thu.ToString();

            dayStr = Enum.GetName(typeof(Weekday), 4);

            int satVal = (int)Weekday.Sat;

            Weekday sunday = (Weekday)Enum.ToObject(typeof(Weekday), 11);

            foreach (var day in Enum.GetValues(typeof(Weekday)))
            {
                Console.WriteLine(day);
            }

            foreach (var weekDayStr in Enum.GetNames(typeof(Weekday)))
            {
                Console.WriteLine(weekDayStr);
            }

            Type enumType = Enum.GetUnderlyingType(typeof(Month));
            Console.WriteLine("Typ towarzyszący dla typu wyliczeniowego Month: " + enumType);

            bool hasFriday = Enum.IsDefined(typeof(Weekday), Weekday.Fri);
            hasFriday = Enum.IsDefined(typeof(Weekday), 5);
            hasFriday = Enum.IsDefined(typeof(Weekday), "Fri");

            Console.ReadKey();
        }

        static DateTime FindAvailableDate(Months monthToSearch)
        {
            // pewna logika biznesowa, która zwraca dzień
            return DateTime.Now;
        }

    }
}
